/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.uicontrols.border;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.images.VWImageLoader;
import filenet.vw.toolkit.utils.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderClientActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class VWToolbarBorder
extends JPanel
implements ActionListener,
IVWToolbarBorderClientActionListener {
    public static final Color BGCOLOR_LTGRAY = new Color(220, 221, 222);
    public static final int NONE = 0;
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int EXPOSED_FIELDS = 4;
    public static final int ADD = 16;
    public static final int MODIFY = 32;
    public static final int COPY = 64;
    public static final int INITATT = 256;
    public static final int STEPUSAGE = 512;
    public static final int SORT_ASCENDING = 1024;
    public static final int RULEUSAGE = 4096;
    public static final int MAPUSAGE = 8192;
    public static final int MILESTONEUSAGE = 16384;
    public static final int IMPORT = 65536;
    public static final int ADVANCED = 131072;
    public static final int CHECK_WFNAME = 262144;
    public static final int VALIDATE = 0x100000;
    public static final int PUBLISH = 0x200000;
    public static final int REFRESH = 0x400000;
    public static final int SELECT = 0x1000000;
    public static final int DELETE = 0x10000000;
    public static final int HELP = 0x20000000;
    public static final int BLANK = 0x40000000;
    public static final int ALL = Integer.MAX_VALUE;
    private JLabel m_titleLabel = null;
    private int m_flags = 0;
    private JPanel m_toolbarPanel = null;
    private JPanel m_clientPanel = null;
    private GridBagConstraints m_toolbarGridCons = null;
    private Vector m_listeners = null;
    private JButton m_upButton = null;
    private JButton m_downButton = null;
    private JButton m_exposedFieldsButton = null;
    private JButton m_addButton = null;
    private JButton m_modifyButton = null;
    private JButton m_copyButton = null;
    private JToggleButton m_initAttButton = null;
    private JButton m_stepUsageButton = null;
    private JButton m_sortAscendingButton = null;
    private JButton m_ruleUsageButton = null;
    private JButton m_submapUsageButton = null;
    private JButton m_milestoneUsageButton = null;
    private JButton m_importButton = null;
    private JButton m_advancedButton = null;
    private JButton m_checkWorkflowNameButton = null;
    private JButton m_validateButton = null;
    private JButton m_publishButton = null;
    private JButton m_refreshButton = null;
    private JButton m_selectButton = null;
    private JButton m_deleteButton = null;
    private JButton m_helpButton = null;

    public VWToolbarBorder(String title) {
        try {
            this.init(title, 0, null, false, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWToolbarBorder(String title, int flags) {
        try {
            this.init(title, flags, null, false, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWToolbarBorder(String title, int flags, String toolTipIconText) {
        try {
            this.init(title, flags, null, false, toolTipIconText);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWToolbarBorder(String title, int flags, JPanel panel) {
        try {
            this.init(title, flags, panel, false, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWToolbarBorder(String title, int flags, boolean bAddSpace) {
        try {
            this.init(title, flags, null, bAddSpace, null);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setTitle(String title) {
        try {
            if (this.m_titleLabel != null) {
                this.m_titleLabel.setText(title);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setToolbarBackground(Color bgColor) {
        try {
            if (this.m_toolbarPanel != null) {
                this.m_toolbarPanel.setBackground(bgColor);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public JLabel getTitleLabel() {
        return this.m_titleLabel;
    }

    public JPanel getClientPanel() {
        return this.m_clientPanel;
    }

    public int getControlStatus(int nControlID) {
        try {
            AbstractButton button = this.getControl(nControlID);
            if (button != null) {
                int nStatus = button.isEnabled() ? 1 : 2;
                return nStatus |= button.isSelected() ? 4 : 8;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return 0;
    }

    public void setTooltip(int nControlID, String tooltip) {
        AbstractButton button = this.getControl(nControlID);
        if (button != null) {
            button.setToolTipText(VWStringUtils.formatToolTip(tooltip, -1));
        }
    }

    public void releaseReferences() {
        this.removeReferences();
    }

    public void releaseResources() {
        this.removeReferences();
    }

    public void removeReferences() {
        this.m_titleLabel = null;
        if (this.m_toolbarPanel != null) {
            this.m_toolbarPanel.removeAll();
            this.m_toolbarPanel.setLayout(null);
            this.m_toolbarPanel = null;
        }
        if (this.m_clientPanel != null) {
            this.m_clientPanel.removeAll();
            this.m_clientPanel.setLayout(null);
            this.m_clientPanel = null;
        }
        if (this.m_upButton != null) {
            this.m_upButton.removeActionListener(this);
            this.m_upButton = null;
        }
        if (this.m_downButton != null) {
            this.m_downButton.removeActionListener(this);
            this.m_downButton = null;
        }
        if (this.m_exposedFieldsButton != null) {
            this.m_exposedFieldsButton.removeActionListener(this);
            this.m_exposedFieldsButton = null;
        }
        if (this.m_addButton != null) {
            this.m_addButton.removeActionListener(this);
            this.m_addButton = null;
        }
        if (this.m_modifyButton != null) {
            this.m_modifyButton.removeActionListener(this);
            this.m_modifyButton = null;
        }
        if (this.m_copyButton != null) {
            this.m_copyButton.removeActionListener(this);
            this.m_copyButton = null;
        }
        if (this.m_initAttButton != null) {
            this.m_initAttButton.removeActionListener(this);
            this.m_initAttButton = null;
        }
        if (this.m_stepUsageButton != null) {
            this.m_stepUsageButton.removeActionListener(this);
            this.m_stepUsageButton = null;
        }
        if (this.m_sortAscendingButton != null) {
            this.m_sortAscendingButton.removeActionListener(this);
            this.m_sortAscendingButton = null;
        }
        if (this.m_ruleUsageButton != null) {
            this.m_ruleUsageButton.removeActionListener(this);
            this.m_ruleUsageButton = null;
        }
        if (this.m_submapUsageButton != null) {
            this.m_submapUsageButton.removeActionListener(this);
            this.m_submapUsageButton = null;
        }
        if (this.m_milestoneUsageButton != null) {
            this.m_milestoneUsageButton.removeActionListener(this);
            this.m_milestoneUsageButton = null;
        }
        if (this.m_importButton != null) {
            this.m_importButton.removeActionListener(this);
            this.m_importButton = null;
        }
        if (this.m_advancedButton != null) {
            this.m_advancedButton.removeActionListener(this);
            this.m_advancedButton = null;
        }
        if (this.m_checkWorkflowNameButton != null) {
            this.m_checkWorkflowNameButton.removeActionListener(this);
            this.m_checkWorkflowNameButton = null;
        }
        if (this.m_validateButton != null) {
            this.m_validateButton.removeActionListener(this);
            this.m_validateButton = null;
        }
        if (this.m_publishButton != null) {
            this.m_publishButton.removeActionListener(this);
            this.m_publishButton = null;
        }
        if (this.m_refreshButton != null) {
            this.m_refreshButton.removeActionListener(this);
            this.m_refreshButton = null;
        }
        if (this.m_selectButton != null) {
            this.m_selectButton.removeActionListener(this);
            this.m_selectButton = null;
        }
        if (this.m_deleteButton != null) {
            this.m_deleteButton.removeActionListener(this);
            this.m_deleteButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton = null;
        }
        this.m_toolbarGridCons = null;
        if (this.m_listeners != null) {
            this.m_listeners.removeAllElements();
            this.m_listeners = null;
        }
        this.removeAll();
    }

    public void addToolbarBorderActionNotifier(IVWToolbarBorderActionListener l) {
        this.m_listeners.addElement(l);
    }

    public void removeToolbarBorderActionNotifier(IVWToolbarBorderActionListener l) {
        this.m_listeners.removeElement(l);
    }

    public void notifyToolbarBorderActionPerformed(Object source, int id) {
        VWToolbarBorderActionEvent event = null;
        try {
            if (this.m_listeners != null) {
                event = new VWToolbarBorderActionEvent(source, id);
                for (int i = 0; i < this.m_listeners.size(); ++i) {
                    ((IVWToolbarBorderActionListener)this.m_listeners.elementAt(i)).toolbarBorderActionPerformed(event);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void clientActionPerformed(VWToolbarBorderClientActionEvent event) {
        try {
            if (event.getSource() == this.m_clientPanel) {
                switch (event.getID()) {
                    case 1: {
                        this.onToolbarButtonEnable(event.getControlIDs(), true);
                        break;
                    }
                    case 2: {
                        this.onToolbarButtonEnable(event.getControlIDs(), false);
                        break;
                    }
                    case 4: {
                        this.onToolbarButtonSelect(event.getControlIDs(), true);
                        break;
                    }
                    case 8: {
                        this.onToolbarButtonSelect(event.getControlIDs(), false);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source == this.m_upButton) {
                this.notifyToolbarBorderActionPerformed(this, 1);
            } else if (source == this.m_downButton) {
                this.notifyToolbarBorderActionPerformed(this, 2);
            } else if (source == this.m_exposedFieldsButton) {
                this.notifyToolbarBorderActionPerformed(this, 4);
            } else if (source == this.m_addButton) {
                this.notifyToolbarBorderActionPerformed(this, 16);
            } else if (source == this.m_modifyButton) {
                this.notifyToolbarBorderActionPerformed(this, 32);
            } else if (source == this.m_copyButton) {
                this.notifyToolbarBorderActionPerformed(this, 64);
            } else if (source == this.m_initAttButton) {
                this.notifyToolbarBorderActionPerformed(this, 256);
            } else if (source == this.m_stepUsageButton) {
                this.notifyToolbarBorderActionPerformed(this, 512);
            } else if (source == this.m_sortAscendingButton) {
                this.notifyToolbarBorderActionPerformed(this, 1024);
            } else if (source == this.m_ruleUsageButton) {
                this.notifyToolbarBorderActionPerformed(this, 4096);
            } else if (source == this.m_submapUsageButton) {
                this.notifyToolbarBorderActionPerformed(this, 8192);
            } else if (source == this.m_milestoneUsageButton) {
                this.notifyToolbarBorderActionPerformed(this, 16384);
            } else if (source == this.m_importButton) {
                this.notifyToolbarBorderActionPerformed(this, 65536);
            } else if (source == this.m_advancedButton) {
                this.notifyToolbarBorderActionPerformed(this, 131072);
            } else if (source == this.m_checkWorkflowNameButton) {
                this.notifyToolbarBorderActionPerformed(this, 262144);
            } else if (source == this.m_validateButton) {
                this.notifyToolbarBorderActionPerformed(this, 0x100000);
            } else if (source == this.m_publishButton) {
                this.notifyToolbarBorderActionPerformed(this, 0x200000);
            } else if (source == this.m_refreshButton) {
                this.notifyToolbarBorderActionPerformed(this, 0x400000);
            } else if (source == this.m_selectButton) {
                this.notifyToolbarBorderActionPerformed(this, 0x1000000);
            } else if (source == this.m_deleteButton) {
                this.notifyToolbarBorderActionPerformed(this, 0x10000000);
            } else if (source == this.m_helpButton) {
                this.notifyToolbarBorderActionPerformed(this, 0x20000000);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void init(String title, int flags, JPanel clientPanel, boolean bAddSpace, String toolTipIconText) {
        try {
            this.m_flags = flags;
            this.m_clientPanel = clientPanel != null ? clientPanel : new JPanel();
            if (bAddSpace) {
                this.setLayout(new BorderLayout(4, 4));
            } else {
                this.setLayout(new BorderLayout());
            }
            this.createToolbar(title, toolTipIconText);
            this.add((Component)this.m_clientPanel, "Center");
            this.m_listeners = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createToolbar(String title, String toolTipIconText) {
        try {
            this.m_toolbarPanel = new JPanel();
            this.m_toolbarPanel.setLayout(new GridBagLayout());
            this.setToolbarBackground(BGCOLOR_LTGRAY);
            this.m_toolbarGridCons = new GridBagConstraints();
            this.createBorderTitle(title, toolTipIconText);
            this.createToolbarControls();
            this.add((Component)this.m_toolbarPanel, "First");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createToolbarControls() {
        try {
            JLabel blankLabel;
            if (this.m_toolbarPanel == null) {
                return;
            }
            String title = this.m_titleLabel.getText();
            this.m_toolbarGridCons.gridy = 0;
            this.m_toolbarGridCons.fill = 0;
            this.m_toolbarGridCons.weightx = 0.0;
            this.m_toolbarGridCons.weighty = 0.0;
            this.m_toolbarGridCons.anchor = 22;
            this.m_toolbarGridCons.gridheight = 1;
            this.m_toolbarGridCons.gridwidth = 1;
            this.m_toolbarGridCons.insets = new Insets(0, 0, 0, 0);
            if ((this.m_flags & 1) != 0) {
                this.m_upButton = (JButton)VWImageLoader.createToolBarButton("up.gif", VWResource.s_up, false);
                if (this.m_upButton != null) {
                    this.m_upButton.addActionListener(this);
                    this.m_upButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_upButton.setName("m_upButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_upButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_upButton, this.m_toolbarPanel, title + VWResource.s_up, title + VWResource.s_up);
                }
            }
            if ((this.m_flags & 2) != 0) {
                this.m_downButton = (JButton)VWImageLoader.createToolBarButton("down.gif", VWResource.s_down, false);
                if (this.m_downButton != null) {
                    this.m_downButton.addActionListener(this);
                    this.m_downButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_downButton.setName("m_downButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_downButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_downButton, this.m_toolbarPanel, title + VWResource.s_down, title + VWResource.s_down);
                }
            }
            if ((this.m_flags & 4) != 0) {
                this.m_exposedFieldsButton = (JButton)VWImageLoader.createToolBarButton("exposedfields.gif", VWResource.s_exposedDataFields, false);
                if (this.m_exposedFieldsButton != null) {
                    this.m_exposedFieldsButton.addActionListener(this);
                    this.m_exposedFieldsButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_exposedFieldsButton.setName("m_exposedFieldsButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_exposedFieldsButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_exposedFieldsButton, this.m_toolbarPanel, title + VWResource.s_exposedDataFields, title + VWResource.s_exposedDataFields);
                }
            }
            if ((this.m_flags & 0x10) != 0) {
                this.m_addButton = (JButton)VWImageLoader.createToolBarButton("new.gif", VWResource.s_add, false);
                if (this.m_addButton != null) {
                    this.m_addButton.addActionListener(this);
                    this.m_addButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_addButton.setName("m_addButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_addButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_addButton, this.m_toolbarPanel, title + VWResource.s_add, title + VWResource.s_add);
                }
            }
            if ((this.m_flags & 0x20) != 0) {
                this.m_modifyButton = (JButton)VWImageLoader.createToolBarButton("update.gif", VWResource.s_modify, false);
                if (this.m_modifyButton != null) {
                    this.m_modifyButton.addActionListener(this);
                    this.m_modifyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_modifyButton.setName("m_modifyButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_modifyButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_modifyButton, this.m_toolbarPanel, title + VWResource.s_modify, title + VWResource.s_modify);
                }
            }
            if ((this.m_flags & 0x40) != 0) {
                this.m_copyButton = (JButton)VWImageLoader.createToolBarButton("copy.gif", VWResource.s_copy, false);
                if (this.m_copyButton != null) {
                    this.m_copyButton.addActionListener(this);
                    this.m_copyButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_copyButton.setName("m_copyButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_copyButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_copyButton, this.m_toolbarPanel, title + VWResource.s_copy, title + VWResource.s_copy);
                }
            }
            if ((this.m_flags & 0x100) != 0) {
                this.m_initAttButton = (JToggleButton)VWImageLoader.createToolBarButton("initiatingatt.gif", VWResource.s_initAttachment, true);
                if (this.m_initAttButton != null) {
                    this.m_initAttButton.setSelected(false);
                    this.m_initAttButton.addActionListener(this);
                    this.m_initAttButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_initAttButton.setName("m_initAttButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_initAttButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_initAttButton, this.m_toolbarPanel, title + VWResource.s_initAttachment, title + VWResource.s_initAttachment);
                }
            }
            if ((this.m_flags & 0x200) != 0) {
                this.m_stepUsageButton = (JButton)VWImageLoader.createToolBarButton("stepusage.gif", VWResource.s_fieldUsage, false);
                if (this.m_stepUsageButton != null) {
                    this.m_stepUsageButton.addActionListener(this);
                    this.m_stepUsageButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_stepUsageButton.setName("m_stepUsageButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_stepUsageButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_stepUsageButton, this.m_toolbarPanel, title + VWResource.s_fieldUsage, title + VWResource.s_fieldUsage);
                }
            }
            if ((this.m_flags & 0x400) != 0) {
                this.m_sortAscendingButton = (JButton)VWImageLoader.createToolBarButton("sortAscending.gif", VWResource.s_sortAscending, false);
                if (this.m_sortAscendingButton != null) {
                    this.m_sortAscendingButton.addActionListener(this);
                    this.m_sortAscendingButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_sortAscendingButton.setName("m_sortAscendingButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_sortAscendingButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_sortAscendingButton, this.m_toolbarPanel, title + VWResource.s_sortAscending, title + VWResource.s_sortAscending);
                }
            }
            if ((this.m_flags & 0x1000) != 0) {
                this.m_ruleUsageButton = (JButton)VWImageLoader.createToolBarButton("stepusage.gif", VWResource.s_ruleUsage, false);
                if (this.m_ruleUsageButton != null) {
                    this.m_ruleUsageButton.addActionListener(this);
                    this.m_ruleUsageButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_ruleUsageButton.setName("m_ruleUsageButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_ruleUsageButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_ruleUsageButton, this.m_toolbarPanel, title + VWResource.s_ruleUsage, title + VWResource.s_ruleUsage);
                }
            }
            if ((this.m_flags & 0x2000) != 0) {
                this.m_submapUsageButton = (JButton)VWImageLoader.createToolBarButton("mapusage.gif", VWResource.s_submapUsage, false);
                if (this.m_submapUsageButton != null) {
                    this.m_submapUsageButton.addActionListener(this);
                    this.m_submapUsageButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_submapUsageButton.setName("m_submapUsageButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_submapUsageButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_submapUsageButton, this.m_toolbarPanel, title + VWResource.s_submapUsage, title + VWResource.s_submapUsage);
                }
            }
            if ((this.m_flags & 0x4000) != 0) {
                this.m_milestoneUsageButton = (JButton)VWImageLoader.createToolBarButton("milestoneusage.gif", VWResource.s_milestoneUsage, false);
                if (this.m_milestoneUsageButton != null) {
                    this.m_milestoneUsageButton.addActionListener(this);
                    this.m_milestoneUsageButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_milestoneUsageButton.setName("m_milestoneUsageButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_milestoneUsageButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_milestoneUsageButton, this.m_toolbarPanel, title + VWResource.s_milestoneUsage, title + VWResource.s_milestoneUsage);
                }
            }
            if ((this.m_flags & 0x10000) != 0) {
                this.m_importButton = (JButton)VWImageLoader.createToolBarButton("import.gif", VWResource.s_import, false);
                if (this.m_importButton != null) {
                    this.m_importButton.addActionListener(this);
                    this.m_importButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_importButton.setName("m_importButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_importButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_importButton, this.m_toolbarPanel, title + VWResource.s_import, title + VWResource.s_import);
                }
            }
            if ((this.m_flags & 0x20000) != 0) {
                this.m_advancedButton = (JButton)VWImageLoader.createToolBarButton("advanced.gif", VWResource.s_advanced, false);
                if (this.m_advancedButton != null) {
                    this.m_advancedButton.addActionListener(this);
                    this.m_advancedButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_advancedButton.setName("m_advancedButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_advancedButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_advancedButton, this.m_toolbarPanel, title + VWResource.s_advanced, title + VWResource.s_advanced);
                }
            }
            if ((this.m_flags & 0x40000) != 0) {
                this.m_checkWorkflowNameButton = (JButton)VWImageLoader.createToolBarButton("checkname.gif", VWResource.s_checkWorkflowName, false);
                if (this.m_checkWorkflowNameButton != null) {
                    this.m_checkWorkflowNameButton.addActionListener(this);
                    this.m_checkWorkflowNameButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_checkWorkflowNameButton.setName("m_checkWorkflowNameButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_checkWorkflowNameButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_checkWorkflowNameButton, this.m_toolbarPanel, title + VWResource.s_checkWorkflowName, title + VWResource.s_checkWorkflowName);
                }
            }
            if ((this.m_flags & 0x100000) != 0) {
                this.m_validateButton = (JButton)VWImageLoader.createToolBarButton("validate.gif", VWResource.s_validate, false);
                if (this.m_validateButton != null) {
                    this.m_validateButton.addActionListener(this);
                    this.m_validateButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_validateButton.setName("m_validateButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_validateButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_validateButton, this.m_toolbarPanel, title + VWResource.s_validate, title + VWResource.s_validate);
                }
            }
            if ((this.m_flags & 0x200000) != 0) {
                this.m_publishButton = (JButton)VWImageLoader.createToolBarButton("publish.gif", VWResource.s_publish, false);
                if (this.m_publishButton != null) {
                    this.m_publishButton.addActionListener(this);
                    this.m_publishButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_publishButton.setName("m_publishButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_publishButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_publishButton, this.m_toolbarPanel, title + VWResource.s_publish, title + VWResource.s_publish);
                }
            }
            if ((this.m_flags & 0x400000) != 0) {
                this.m_refreshButton = (JButton)VWImageLoader.createToolBarButton("refresh.gif", VWResource.s_refresh, false);
                if (this.m_refreshButton != null) {
                    this.m_refreshButton.addActionListener(this);
                    this.m_refreshButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_refreshButton.setName("m_refreshButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_refreshButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_refreshButton, this.m_toolbarPanel, title + VWResource.s_refresh, title + VWResource.s_refresh);
                }
            }
            if ((this.m_flags & 0x1000000) != 0) {
                this.m_selectButton = (JButton)VWImageLoader.createToolBarButton("select.gif", VWResource.s_select, false);
                if (this.m_selectButton != null) {
                    this.m_selectButton.addActionListener(this);
                    this.m_selectButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_selectButton.setName("m_selectButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarPanel.add((Component)this.m_selectButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_selectButton, this.m_toolbarPanel, title + VWResource.s_select, title + VWResource.s_select);
                }
            }
            if ((this.m_flags & 0x10000000) != 0) {
                this.m_deleteButton = (JButton)VWImageLoader.createToolBarButton("delete.gif", VWResource.s_delete, false);
                if (this.m_deleteButton != null) {
                    this.m_deleteButton.addActionListener(this);
                    this.m_deleteButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_deleteButton.setName("m_deleteButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarGridCons.insets = new Insets(0, 5, 0, 0);
                    this.m_toolbarPanel.add((Component)this.m_deleteButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_deleteButton, this.m_toolbarPanel, title + VWResource.s_delete, title + VWResource.s_delete);
                    this.m_toolbarGridCons.insets = new Insets(0, 0, 0, 0);
                }
            }
            if ((this.m_flags & 0x20000000) != 0) {
                this.m_helpButton = (JButton)VWImageLoader.createToolBarButton("help.gif", VWResource.s_help, false);
                if (this.m_helpButton != null) {
                    this.m_helpButton.addActionListener(this);
                    this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
                    this.m_helpButton.setName("m_helpButton_VWToolbarBorder");
                    ++this.m_toolbarGridCons.gridx;
                    this.m_toolbarGridCons.insets = new Insets(0, 5, 0, 0);
                    this.m_toolbarPanel.add((Component)this.m_helpButton, this.m_toolbarGridCons);
                    VWAccessibilityHelper.setAccessibility(this.m_helpButton, this.m_toolbarPanel, title + VWResource.s_help, title + VWResource.s_help);
                    this.m_toolbarGridCons.insets = new Insets(0, 0, 0, 0);
                }
            }
            if ((this.m_flags & 0x40000000) != 0 && (blankLabel = new JLabel(VWImageLoader.createImageIconNoMessage("blank.gif"))) != null) {
                blankLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                ++this.m_toolbarGridCons.gridx;
                this.m_toolbarPanel.add((Component)blankLabel, this.m_toolbarGridCons);
                this.m_toolbarGridCons.insets = new Insets(0, 0, 0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createBorderTitle(String title, String toolTipIconText) {
        try {
            this.m_titleLabel = new JLabel(title);
            this.m_toolbarGridCons.gridx = 0;
            this.m_toolbarGridCons.gridy = 0;
            this.m_toolbarGridCons.weightx = 1.0;
            this.m_toolbarGridCons.weighty = 0.0;
            this.m_toolbarGridCons.gridheight = 1;
            this.m_toolbarGridCons.gridwidth = 1;
            this.m_toolbarGridCons.insets = new Insets(2, 2, 2, 2);
            this.m_toolbarGridCons.anchor = 23;
            this.m_toolbarGridCons.fill = 1;
            if (this.m_toolbarPanel != null && this.m_titleLabel != null) {
                this.m_toolbarPanel.add((Component)this.m_titleLabel, this.m_toolbarGridCons);
                VWAccessibilityHelper.setAccessibility(this.m_titleLabel, this.m_toolbarPanel, title, title);
            }
            if (toolTipIconText != null && toolTipIconText.length() > 0 && this.m_titleLabel != null) {
                this.m_titleLabel.setToolTipText(VWStringUtils.formatToolTip(toolTipIconText, -1));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onToolbarButtonEnable(int controlIDs, boolean bEnable) {
        try {
            boolean bAll;
            boolean bl = bAll = (controlIDs & Integer.MAX_VALUE) == Integer.MAX_VALUE;
            if (this.m_upButton != null && ((controlIDs & 1) != 0 || bAll)) {
                this.m_upButton.setEnabled(bEnable);
                this.m_upButton.setFocusable(bEnable);
            }
            if (this.m_downButton != null && ((controlIDs & 2) != 0 || bAll)) {
                this.m_downButton.setEnabled(bEnable);
                this.m_downButton.setFocusable(bEnable);
            }
            if (this.m_exposedFieldsButton != null && ((controlIDs & 4) != 0 || bAll)) {
                this.m_exposedFieldsButton.setEnabled(bEnable);
                this.m_exposedFieldsButton.setFocusable(bEnable);
            }
            if (this.m_addButton != null && ((controlIDs & 0x10) != 0 || bAll)) {
                this.m_addButton.setEnabled(bEnable);
                this.m_addButton.setFocusable(bEnable);
            }
            if (this.m_modifyButton != null && ((controlIDs & 0x20) != 0 || bAll)) {
                this.m_modifyButton.setEnabled(bEnable);
                this.m_modifyButton.setFocusable(bEnable);
            }
            if (this.m_copyButton != null && ((controlIDs & 0x40) != 0 || bAll)) {
                this.m_copyButton.setEnabled(bEnable);
                this.m_copyButton.setFocusable(bEnable);
            }
            if (this.m_initAttButton != null && ((controlIDs & 0x100) != 0 || bAll)) {
                this.m_initAttButton.setEnabled(bEnable);
                this.m_initAttButton.setFocusable(bEnable);
            }
            if (this.m_stepUsageButton != null && ((controlIDs & 0x200) != 0 || bAll)) {
                this.m_stepUsageButton.setEnabled(bEnable);
                this.m_stepUsageButton.setFocusable(bEnable);
            }
            if (this.m_sortAscendingButton != null && ((controlIDs & 0x400) != 0 || bAll)) {
                this.m_sortAscendingButton.setEnabled(bEnable);
                this.m_sortAscendingButton.setFocusable(bEnable);
            }
            if (this.m_ruleUsageButton != null && ((controlIDs & 0x1000) != 0 || bAll)) {
                this.m_ruleUsageButton.setEnabled(bEnable);
                this.m_ruleUsageButton.setFocusable(bEnable);
            }
            if (this.m_submapUsageButton != null && ((controlIDs & 0x2000) != 0 || bAll)) {
                this.m_submapUsageButton.setEnabled(bEnable);
                this.m_submapUsageButton.setFocusable(bEnable);
            }
            if (this.m_milestoneUsageButton != null && ((controlIDs & 0x4000) != 0 || bAll)) {
                this.m_milestoneUsageButton.setEnabled(bEnable);
                this.m_milestoneUsageButton.setFocusable(bEnable);
            }
            if (this.m_importButton != null && ((controlIDs & 0x10000) != 0 || bAll)) {
                this.m_importButton.setEnabled(bEnable);
                this.m_importButton.setFocusable(bEnable);
            }
            if (this.m_advancedButton != null && ((controlIDs & 0x20000) != 0 || bAll)) {
                this.m_advancedButton.setEnabled(bEnable);
                this.m_advancedButton.setFocusable(bEnable);
            }
            if (this.m_checkWorkflowNameButton != null && ((controlIDs & 0x40000) != 0 || bAll)) {
                this.m_checkWorkflowNameButton.setEnabled(bEnable);
                this.m_checkWorkflowNameButton.setFocusable(bEnable);
            }
            if (this.m_validateButton != null && ((controlIDs & 0x100000) != 0 || bAll)) {
                this.m_validateButton.setEnabled(bEnable);
                this.m_validateButton.setFocusable(bEnable);
            }
            if (this.m_publishButton != null && ((controlIDs & 0x200000) != 0 || bAll)) {
                this.m_publishButton.setEnabled(bEnable);
                this.m_publishButton.setFocusable(bEnable);
            }
            if (this.m_refreshButton != null && ((controlIDs & 0x400000) != 0 || bAll)) {
                this.m_refreshButton.setEnabled(bEnable);
                this.m_refreshButton.setFocusable(bEnable);
            }
            if (this.m_selectButton != null && ((controlIDs & 0x1000000) != 0 || bAll)) {
                this.m_selectButton.setEnabled(bEnable);
                this.m_selectButton.setFocusable(bEnable);
            }
            if (this.m_deleteButton != null && ((controlIDs & 0x10000000) != 0 || bAll)) {
                this.m_deleteButton.setEnabled(bEnable);
                this.m_deleteButton.setFocusable(bEnable);
            }
            if (this.m_helpButton != null && ((controlIDs & 0x20000000) != 0 || bAll)) {
                this.m_helpButton.setEnabled(bEnable);
                this.m_helpButton.setFocusable(bEnable);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onToolbarButtonSelect(int controlIDs, boolean bSelect) {
        try {
            if (this.m_initAttButton != null && (controlIDs & 0x100) != 0) {
                this.m_initAttButton.setSelected(bSelect);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public AbstractButton getControl(int nControlID) {
        try {
            switch (nControlID) {
                case 1: {
                    return this.m_upButton;
                }
                case 2: {
                    return this.m_downButton;
                }
                case 4: {
                    return this.m_exposedFieldsButton;
                }
                case 16: {
                    return this.m_addButton;
                }
                case 32: {
                    return this.m_modifyButton;
                }
                case 64: {
                    return this.m_copyButton;
                }
                case 256: {
                    return this.m_initAttButton;
                }
                case 512: {
                    return this.m_stepUsageButton;
                }
                case 1024: {
                    return this.m_sortAscendingButton;
                }
                case 4096: {
                    return this.m_ruleUsageButton;
                }
                case 8192: {
                    return this.m_submapUsageButton;
                }
                case 16384: {
                    return this.m_milestoneUsageButton;
                }
                case 65536: {
                    return this.m_importButton;
                }
                case 131072: {
                    return this.m_advancedButton;
                }
                case 262144: {
                    return this.m_checkWorkflowNameButton;
                }
                case 0x100000: {
                    return this.m_validateButton;
                }
                case 0x200000: {
                    return this.m_publishButton;
                }
                case 0x400000: {
                    return this.m_refreshButton;
                }
                case 0x1000000: {
                    return this.m_selectButton;
                }
                case 0x10000000: {
                    return this.m_deleteButton;
                }
                case 0x20000000: {
                    return this.m_helpButton;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }
}

